new const NINTENDOMOD_TOAD_PLUGIN[] = "Nintendo Mod X Toad"
new const NINTENDOMOD_TOAD_VERSION[] = "2.1"
new const NINTENDOMOD_TOAD_AUTHOR[] = "Soloist/Mephisto"

/*
	1st Passive: Reinforcements
		* Chance of reviving with all equipments from past round.
	2nd Passive: Decay
		* Enemies suffer from Toad's decay if they are too close to him.
	Skill 1: Theft
		* Steals money when attacks an enemy.
	Skill 2: Vampirism
		* Gains health when damaging enemy.
	Skill 3: Spores
		* Chance of blinding the enemy for a quick period of time.
	PowerUp: Mushroom Cap
		* Immunity for a period of time.

	Based on Soloist's original source code Toad v1.0, updated by Mephisto
	Version 2.1
	Last Updated On 06/09/09

	*************************************************************************************

	Changelog
		Version 2.1
			* Vampirism doesn't work on self-damage anymore
			* Reinforcements bug fixed
			* Theft Skill also affects Toad's team
		Versoin 2.0.2
			* PowerUp time at lvl 12 and 15 increased by 1 sec (equal to other godmode chars)
		Version 2.0.1
			* plugin title changed
		Version 2.0
			* skills have four levels now, PowerUp has three levels
			* lvl cap increased to 15
			* 2nd passive skill added
		Version 1.0
			* Release of the plugin
*/

#include <amxmodx>
#include <cstrike>
#include <fun>
#include <fakemeta>
#include <nintendomod>

new const Float:TOAD_REINFORCEMENTS[11] = {0.05, 0.10, 0.20, 0.30, 0.40, 0.50, 0.60, 0.70, 0.80, 0.90, 1.0};
new const Float:TOAD_VAMPIRISMPROB[4] = {0.333, 0.455, 0.666, 0.75};
new const Float:TOAD_DECAYDMG[5] = {2.5, 2.8, 2.9, 3.0, 3.2};
new const TOAD_DECAYRAD[5] = {350, 370, 380, 390, 400};
new const Float:TOAD_INFECTPROB[5] = {0.15, 0.18, 0.20, 0.22, 0.25};
new const Float:TOAD_INFECTNUM[5] = {16.0, 20.0, 24.0, 28.0, 32.0};
new const TOAD_INFECTDMG[5] = {1, 2, 3, 4, 5};
new const Float:TOAD_MUSHROOMTIME[3] = {4.0, 6.0, 7.0};
new const Float:TOAD_VAMPIRISMPREC[4] = {0.2, 0.3, 0.4, 0.5};
new const Float:TOAD_THEFTPROB[4] = {0.333, 0.455, 0.666, 0.75};
new const TOAD_THEFTMONEY[4] = {100, 200, 300, 400};
new const TOAD_SPORESDMG[4] = {75, 65, 55, 50};

new charName[] = "Toad";
new passiveName[] = "Reinforcements";
new passive2Name[] = "Decay";
new skill1Name[] = "Theft";
new skill2Name[] = "Vampirism";
new skill3Name[] = "Spores";
new powerupName[] = "Mushroom Cap";
new initName[] = "Toad_Init";
new keyDownName[] = "Toad_MushroomCap";

new passiveHelp[] = "Chance of reviving with all equipments from past round.";
new passive2Help[] = "Enemies suffer from Toad's decay if they are too close to him.";
new skill1Help[] = "Steals money when attacks an enemy.";
new skill2Help[] = "Gains health when damaging enemy.";
new skill3Help[] = "Chance of blinding the enemy for a quick period of time.";
new powerupHelp[] = "Immunity for a period of time.";

new PlayerLevel[33];
new PlayerSkill1[33];
new PlayerSkill2[33];
new PlayerSkill3[33];
new PlayerPowerUp[33];

new prevWeapons[33][32];
new prevNvg[33];
new prevShield[33];
new Float:Infected[33];

new bool:diedLastRound[33];
new bool:Blinded[33];

public plugin_init()
{
	if(is_plugin_loaded("Nintendo Mod Xtended") == -1)
	{
		server_print("**********************************");
		server_print("*** Nintendo Mod is not loaded ***");
		server_print("**********************************");
		pause("ae");
		return;
	}

	register_plugin(NINTENDOMOD_TOAD_PLUGIN, NINTENDOMOD_TOAD_VERSION, NINTENDOMOD_TOAD_AUTHOR);

	register_cvar("NintendoMod_Toad_Version", NINTENDOMOD_TOAD_VERSION, FCVAR_SERVER|FCVAR_SPONLY);

	register_event("ResetHUD", "ResetHUD", "b");

	register_event("Damage", "Toad_Damage", "b", "2!0");
	register_event("DeathMsg", "Toad_PassiveDeath", "ae");

	Nintendo_RegisterChar(charName, passiveName, passive2Name, skill1Name, skill2Name, skill3Name, powerupName, initName);
	Nintendo_RegisterHelp(charName, passiveHelp, passive2Help, skill1Help, skill2Help, skill3Help, powerupHelp);
	Nintendo_RegisterKeyDown(charName, keyDownName);

	register_srvcmd(initName, initName);
	register_srvcmd(keyDownName, keyDownName);
}

public plugin_precache()
{
	engfunc(EngFunc_PrecacheSound, "nintendomod/toad_decay.wav");
	engfunc(EngFunc_PrecacheSound, "nintendomod/toad_infect.wav");
}

public client_connect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);

	return PLUGIN_CONTINUE;
}

public client_disconnect(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	InitPlayer(id);
	remove_task(id);

	return PLUGIN_CONTINUE;
}

public InitPlayer(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	PlayerLevel[id] = 0;
	PlayerSkill1[id] = 0;
	PlayerSkill2[id] = 0;
	PlayerSkill3[id] = 0;
	PlayerPowerUp[id] = 0;

	return PLUGIN_CONTINUE;
}

public Toad_Init()
{
	new temp[33];
	read_argv(1, temp, 32);
	new id = str_to_num(temp);

	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	read_argv(2, temp, 32);
	new index  = str_to_num(temp);

	if(index == 0)
	{
		read_argv(3, temp, 32);
		new level = str_to_num(temp);
		read_argv(4, temp, 32);
		new skill1 = str_to_num(temp);
		read_argv(5, temp, 32);
		new skill2 = str_to_num(temp);
		read_argv(6, temp, 32);
		new skill3 = str_to_num(temp);
		read_argv(7, temp, 32);
		new powerup = str_to_num(temp);

		PlayerLevel[id] = level;
		PlayerSkill1[id] = skill1;
		PlayerSkill2[id] = skill2;
		PlayerSkill3[id] = skill3;
		PlayerPowerUp[id] = powerup;
	}
	else
	{
		read_argv(3, temp, 32);
		new value = str_to_num(temp);

		switch(index)
		{
			case 1: PlayerLevel[id] = value;
			case 2: PlayerSkill1[id] = value;
			case 3: PlayerSkill2[id] = value;
			case 4: PlayerSkill3[id] = value;
			case 5: PlayerPowerUp[id] = value;
		}
	}

	ResetHUD(id);

	return PLUGIN_CONTINUE;
}

public ResetHUD(id)
{
	remove_task(id);
	Blinded[id] = false;
	Infected[id] = 0.0;

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(diedLastRound[id])
		set_task(0.1, "Toad_Passive", id);
	Toad_Decay(id);

	return PLUGIN_CONTINUE;
}

public Toad_Damage(id)
{
	if(!Nintendo_Active() || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart)
	new damage = read_data(2);

	if(!Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(Nintendo_HasChar(id, charName))
	{
		Toad_Spores(id, attacker, damage);
		if(PlayerLevel[id] > 10 && id != attacker && weapon == CSW_KNIFE)
		{
			new Float:randomnumber = random_float(0.0, 1.0);
			if(randomnumber <= TOAD_INFECTPROB[PlayerLevel[id] - 11])
			{
				new parm[2];
				parm[0] = id;
				parm[1] = attacker;
				Infected[attacker] += TOAD_INFECTNUM[PlayerLevel[id] - 11];
				Nintendo_StatusHUD(attacker, "You have been infected", 1);
				emit_sound(attacker, CHAN_AUTO, "nintendomod/toad_infect.wav", 0.6, ATTN_NORM, 0, PITCH_NORM);
				Nintendo_StatusHUD(id, "[Toad] You infected someone", 1);
				if(Infected[attacker] - TOAD_INFECTNUM[PlayerLevel[id] - 11] <= 0.0)
					Toad_Infection(parm);
			}
		}
	}
	if(Nintendo_HasChar(attacker, charName))
	{
		Toad_Theft(id, attacker, damage);
		Toad_Vampirism(id, attacker, damage);
		if(PlayerLevel[attacker] > 10 && id != attacker && weapon == CSW_KNIFE)
		{
			new Float:randomnumber = random_float(0.0, 1.0);
			if(randomnumber <= TOAD_INFECTPROB[PlayerLevel[attacker] - 11])
			{
				new parm[2];
				parm[0] = attacker;
				parm[1] = id;
				Infected[id] += TOAD_INFECTNUM[PlayerLevel[attacker] - 11];
				Nintendo_StatusHUD(id, "You have been infected", 1);
				emit_sound(id, CHAN_AUTO, "nintendomod/toad_infect.wav", 0.6, ATTN_NORM, 0, PITCH_NORM);
				Nintendo_StatusHUD(attacker, "[Toad] You infected someone", 1);
				if(Infected[id] - TOAD_INFECTNUM[PlayerLevel[attacker] - 11] <= 0.0)
					Toad_Infection(parm);
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Toad_Passive(id) // 1st Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new Float:randomnumber = random_float(0.0, 1.0);
	new Float:prob = (PlayerLevel[id] > 10 ? TOAD_REINFORCEMENTS[10] : TOAD_REINFORCEMENTS[PlayerLevel[id]]);
	if(randomnumber <= prob)
	{
		Toad_GiveWeapons(id);
		Nintendo_ScreenFade(id, (1<<0), (1<<10), (1<<12), 0, 255, 0, 100);
	}

	diedLastRound[id] = false;

	return PLUGIN_CONTINUE;
}

public Toad_Decay(id) // 2nd Passive
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;
	if(PlayerLevel[id] <= 10 || !is_user_alive(id))
		return PLUGIN_CONTINUE;

	new players[32], num, player;
	get_players(players, num);
	for(new i = 0; i < num; i++)
	{
		player = players[i];
		if(Nintendo_IsValidPlayer(player, true))
		{
			if((get_user_team(id) != get_user_team(player)))
			{
				new decay[3], victim[3];
				get_user_origin(id, decay);
				get_user_origin(player, victim);
				new dist = get_distance(decay, victim);
				if(dist <= TOAD_DECAYRAD[PlayerLevel[id] - 11])
				{
					new dam = floatround(float(TOAD_DECAYRAD[PlayerLevel[id]-11]-dist+50) / float(TOAD_DECAYRAD[PlayerLevel[id]-11]) * TOAD_DECAYDMG[PlayerLevel[id]-11]);
					if(dam > 0)
					{
						emit_sound(player, CHAN_AUTO, "nintendomod/toad_decay.wav", 0.2, ATTN_NORM, 0, PITCH_NORM);
						Nintendo_ExtraDamage(id, player, dam, "Decay", 0);

						new idorigin[3];
						get_user_origin(id, idorigin);
						message_begin(MSG_ONE, get_user_msgid("Damage"), {0,0,0}, player);
						write_byte(30); // dmg_save
						write_byte(30); // dmg_take 
						write_long(DMG_NERVEGAS); // visibleDamageBits
						write_coord(idorigin[0]); // damageOrigin.x 
						write_coord(idorigin[1]); // damageOrigin.y
						write_coord(idorigin[2]); // damageOrigin.z 
						message_end();
					}
				}
			}
		}
	}
	set_task(3.0, "Toad_Decay", id);

	return PLUGIN_CONTINUE;
}

public Toad_Infection(parm[])
{
	new id = parm[0];
	new victim = parm[1];

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;
	if(PlayerLevel[id] <= 10 || Infected[victim] < 0.0)
	{
		Infected[victim] = 0.0;
		return PLUGIN_CONTINUE;
	}

	Infected[victim] -= 4.0;
	new Float:percentage = (TOAD_INFECTNUM[PlayerLevel[id] - 11] - Infected[victim]) / TOAD_INFECTNUM[PlayerLevel[id] - 11];
	emit_sound(victim, CHAN_AUTO, "nintendomod/toad_decay.wav", 0.2, ATTN_NORM, 0, PITCH_NORM);
	Nintendo_ExtraDamage(id, victim, TOAD_INFECTDMG[PlayerLevel[id] - 11], "Decay Infection", 0);

	new idorigin[3];
	get_user_origin(id, idorigin);
	message_begin(MSG_ONE, get_user_msgid("Damage"), {0,0,0}, victim);
	write_byte(30); // dmg_save
	write_byte(30); // dmg_take 
	write_long(DMG_NERVEGAS); // visibleDamageBits
	write_coord(idorigin[0]); // damageOrigin.x 
	write_coord(idorigin[1]); // damageOrigin.y
	write_coord(idorigin[2]); // damageOrigin.z 
	message_end();

	if(percentage >= 1.0)
		Nintendo_StatusHUD(victim, "Your disease has ended", 1);
	else
		set_task(4.0, "Toad_Infection", id, parm, 2);

	return PLUGIN_CONTINUE;
}

public Toad_PassiveDeath()
{
	new id = read_data(2);

	Infected[id] = 0.0;

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !is_user_connected(id))
		return PLUGIN_HANDLED;

	diedLastRound[id] = true;
	Toad_GetWeapons(id);

	return PLUGIN_CONTINUE;
}

public Toad_GetWeapons(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	for(new i=0; i<32; i++)
		prevWeapons[id][i] = 0;

	new numWeapons;
	get_user_weapons(id, prevWeapons[id], numWeapons);

	prevNvg[id] = cs_get_user_nvg(id);
	prevShield[id] = cs_get_user_shield(id);

	return PLUGIN_CONTINUE;
}

public Toad_GiveWeapons(id)
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	new bool:userHasC4
	if(user_has_weapon(id, CSW_C4))
		userHasC4 = true;
	else
		userHasC4 = false;

	Nintendo_StripUserWeapons(id);

	if(prevNvg[id])
		cs_set_user_nvg(id, prevNvg[id]);

	if(cs_get_user_team(id) == CS_TEAM_CT)
		set_task(0.1, "give_defuse", id);

	Nintendo_GiveItem(id, "weapon_knife");
	set_pev(id, pev_armortype, "CS_ARMOR_VESTHELM");
	set_pev(id, pev_armorvalue, 100);

	new weaponName[32], ammoname[32];
	for(new i = 0; i < 32; i++)
	{
		new weapon = prevWeapons[id][i];

		if(weapon && weapon != CSW_C4)
		{
			switch(weapon)
			{
				case CSW_USP, CSW_MAC10, CSW_UMP45, CSW_MP5NAVY: ammoname="ammo_45acp";
				case CSW_ELITE, CSW_GLOCK18, CSW_TMP: ammoname="ammo_9mm";
				case CSW_FIVESEVEN, CSW_P90: ammoname="ammo_57mm";
				case CSW_DEAGLE: ammoname="ammo_50ae";
				case CSW_P228: ammoname="ammo_357sig";
				case CSW_SCOUT, CSW_G3SG1, CSW_AK47: ammoname="ammo_762nato";
				case CSW_XM1014, CSW_M3: ammoname="ammo_buckshot";
				case CSW_AUG, CSW_SG550, CSW_GALIL, CSW_FAMAS, CSW_M4A1, CSW_SG552: ammoname="ammo_556nato";
				case CSW_M249: ammoname="ammo_556natobox";
				case CSW_AWP: ammoname="ammo_338magnum";
				case CSW_HEGRENADE, CSW_FLASHBANG, CSW_SMOKEGRENADE: ammoname="";
			}

			get_weaponname(weapon, weaponName, 31);
			Nintendo_GiveItem(id, weaponName);
			Nintendo_GiveItem(id, ammoname);
			Nintendo_GiveItem(id, ammoname);
			Nintendo_GiveItem(id, ammoname);
			Nintendo_GiveItem(id, ammoname);
			Nintendo_GiveItem(id, ammoname);
			Nintendo_GiveItem(id, ammoname);
			Nintendo_GiveItem(id, ammoname);
		}
	}

	if(prevShield[id])
		Nintendo_GiveItem(id,"weapon_shield");

	if(userHasC4)
	{
		get_weaponname(CSW_C4, weaponName, 31);
		Nintendo_GiveItem(id, weaponName);
		cs_set_user_plant(id, 1, 1);
	}

	return PLUGIN_CONTINUE;
}

public give_defuse(id)
	cs_set_user_defuse(id, 1);

public Toad_Theft(victim, attacker, damage) // Skill 1
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) || !Nintendo_IsValidPlayer(victim) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(PlayerSkill1[attacker] > 0)
	{
		if(victim != attacker)
		{
			new Float:randomnumber = random_float(0.0, 1.0);
			if(randomnumber <= TOAD_THEFTPROB[PlayerSkill1[attacker] - 1])
			{
				new curVicMoney, newVicMoney, curMoney, newMoney;
				new players[32], num, player;

				// victim
				curVicMoney = cs_get_user_money(victim);
				newVicMoney = curVicMoney - TOAD_THEFTMONEY[PlayerSkill1[attacker] - 1];
				if(newVicMoney < 0) newVicMoney = 0;
				cs_set_user_money(victim, newVicMoney);

				// attacker's team
				get_players(players, num);
				for(new i = 0; i < num; i++)
				{
					player = players[i];
					if(get_user_team(player) != get_user_team(attacker) ||
						(player != attacker && Nintendo_HasChar(player, charName)))
						continue;

					curMoney = cs_get_user_money(player);
					if(player == attacker)
						newMoney = curMoney + TOAD_THEFTMONEY[PlayerSkill1[attacker] - 1];
					else
						newMoney = curMoney + TOAD_THEFTMONEY[PlayerSkill1[attacker] - 1] / 2;
					if(newMoney > 16000) newMoney = 16000;
					cs_set_user_money(player, newMoney);
				}
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Toad_Vampirism(id, attacker, damage) // Skill 2
{
	if(!Nintendo_Active() || !Nintendo_HasChar(attacker, charName) ||
		!Nintendo_IsValidPlayer(id) || !Nintendo_IsValidPlayer(attacker) || id == attacker)
		return PLUGIN_HANDLED;

	if(PlayerSkill2[attacker] > 0)
	{
		new Float:randomnumber = random_float(0.0, 1.0);
		if(randomnumber <= TOAD_VAMPIRISMPROB[PlayerSkill2[attacker] - 1])
		{
			new curHealth = pev(attacker, pev_health);
			new Float:newHealth = float(curHealth + floatround(TOAD_VAMPIRISMPREC[PlayerSkill2[attacker] - 1] * damage));

			if(newHealth > 100.0) newHealth = 100.0;

			Nintendo_SetHealth(attacker, newHealth, false);
		}
	}

	return PLUGIN_CONTINUE;
}

public Toad_Spores(id, attacker, damage) // Skill 3
{
	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id) || !Nintendo_IsValidPlayer(attacker))
		return PLUGIN_HANDLED;

	if(PlayerSkill3[id] > 0)
	{
		if(!Blinded[attacker] && id != attacker)
		{
			if(damage >= TOAD_SPORESDMG[PlayerSkill3[id] - 1])
			{
				Nintendo_ScreenFade(attacker, (~0), (~0), (1<<12), 0, 0, 0, 255);
				Blinded[attacker] = true;
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public Toad_MushroomCap()
{
	new temp[6]
	read_argv(1, temp, 5)
	new id = str_to_num(temp)

	if(!Nintendo_Active() || !Nintendo_HasChar(id, charName) || !Nintendo_IsValidPlayer(id))
		return PLUGIN_HANDLED;

	if(PlayerPowerUp[id] >= 1)
	{
		Nintendo_PowerUpUsed(id, 1, 30);

		set_pev(id, pev_takedamage, 0.0);
		Nintendo_SetGlow(id, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 25);

		set_task(TOAD_MUSHROOMTIME[PlayerPowerUp[id] - 1], "Toad_RemoveGod", id);
	}

	return PLUGIN_CONTINUE;
}

public Toad_RemoveGod(id)
{
	if(!Nintendo_Active())
		return PLUGIN_HANDLED;

	set_pev(id, pev_takedamage, 2.0);
	Nintendo_StatusHUD(id, "[Toad] Mushroom Cap is over", 1);
	Nintendo_SetGlow(id);

	return PLUGIN_CONTINUE;
}
